/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;

public class game_of_life
extends PApplet {
    boolean[][] cells;
    boolean[] state = new boolean[256];

    public void setup() {
        this.frameRate(60.0f);
        this.fill(-16711681);
        this.textSize(50.0f);
        this.cells = new boolean[this.width][this.height];
        this.randomize();
        this.loadPixels();
    }

    public void draw() {
        this.cells = this.gameTick(this.cells);
        this.userInput();
        this.setPixels();
        this.updatePixels();
    }

    public int borderWrapX(int x) {
        if (x == -1) {
            return this.width - 1;
        }
        if (x == this.width) {
            return 0;
        }
        return x;
    }

    public int borderWrapY(int y) {
        if (y == -1) {
            return this.height - 1;
        }
        if (y == this.height) {
            return 0;
        }
        return y;
    }

    public boolean[][] gameTick(boolean[][] oldCells) {
        boolean[][] newCells = new boolean[this.width][this.height];
        int i = 0;
        while (i < this.width) {
            int j = 0;
            while (j < this.height) {
                int neighbours = 0;
                if (oldCells[this.borderWrapX(i - 1)][this.borderWrapY(j - 1)]) {
                    ++neighbours;
                }
                if (oldCells[this.borderWrapX(i)][this.borderWrapY(j - 1)]) {
                    ++neighbours;
                }
                if (oldCells[this.borderWrapX(i + 1)][this.borderWrapY(j - 1)]) {
                    ++neighbours;
                }
                if (oldCells[this.borderWrapX(i - 1)][this.borderWrapY(j)]) {
                    ++neighbours;
                }
                if (neighbours < 4 && oldCells[this.borderWrapX(i + 1)][this.borderWrapY(j)]) {
                    ++neighbours;
                }
                if (neighbours < 4 && oldCells[this.borderWrapX(i - 1)][this.borderWrapY(j + 1)]) {
                    ++neighbours;
                }
                if (neighbours < 4 && oldCells[this.borderWrapX(i)][this.borderWrapY(j + 1)]) {
                    ++neighbours;
                }
                if (neighbours < 4 && oldCells[this.borderWrapX(i + 1)][this.borderWrapY(j + 1)]) {
                    ++neighbours;
                }
                if (oldCells[i][j]) {
                    newCells[i][j] = neighbours == 2 || neighbours == 3;
                } else if (neighbours == 3) {
                    newCells[i][j] = true;
                }
                ++j;
            }
            ++i;
        }
        return newCells;
    }

    public void setPixels() {
        int i = 0;
        while (i < this.width) {
            int pixelsIndex = i;
            int j = 0;
            while (j < this.height) {
                this.pixels[pixelsIndex] = this.cells[i][j] ? -1 : -16777216;
                pixelsIndex += this.width;
                ++j;
            }
            ++i;
        }
    }

    public void userInput() {
        if (this.mousePressed) {
            this.randomize();
        }
    }

    public void randomize() {
        int i = 0;
        while (i < this.width) {
            int j = 0;
            while (j < this.height) {
                if (PApplet.parseInt((float)this.random(2.0f)) == 0) {
                    this.cells[i][j] = true;
                }
                ++j;
            }
            ++i;
        }
    }

    public void settings() {
        this.fullScreen();
        this.noSmooth();
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"--full-screen", "--bgcolor=#666666", "--stop-color=#cccccc", "game_of_life"};
        if (passedArgs != null) {
            PApplet.main((String[])game_of_life.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }
}

